
// Farbtabelle
var colorObj = {
	// IÖB
	rot:			'#ff6f61',
	gelb:			'#ffd531',
	gruendunkel:	'#00ab9d',
	//gruenhell:		'#80d5cb', // = bgColor
	blau:			'#57b9e2',
	blauhell:		'#afd2e6',
	blaudunkel:		'#00448a'
};
colorObj._1 = colorObj.rot;
colorObj._2 = colorObj.gelb;
colorObj._3 = colorObj.gruendunkel;
colorObj._4 = colorObj.blau;
colorObj._5 = colorObj.blauhell;

/**
Excel-Spalten Zuordnungstabelle:
  A |  B |  C |  D |  E |  F |  G |  H |  I |  J |  K |  L |  M |  N |  O |  P |  Q |  R |  S |  T |  U |  V |  W |  X |  Y |  Z |
  0 |  1 |  2 |  3 |  4 |  5 |  6 |  7 |  8 |  9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 | 25 |
  
 AA | AB | AC | AD | AE | AF | AG | AH | AI | AJ | AK | AL | AM | AN | AO | AP | AQ | AR | AS | AT | AU | AV | AW | AX | AY | AZ |
 26 | 27 | 28 | 29 | 30 | 31 | 32 | 33 | 34 | 35 | 36 | 37 | 38 | 39 | 40 | 41 | 42 | 43 | 44 | 45 | 46 | 47 | 48 | 49 | 50 | 51 |
 
 BA | BB | BC | BD | BE | BF | BG | BH | BI | BJ | BK | BL | BM | BN | BO | BP | BQ | BR | BS | BT | BU | BV | BW | BX | BY | BZ |
 52 | 53 | 54 | 55 | 56 | 57 | 58 | 59 | 60 | 61 | 62 | 63 | 64 | 65 | 66 | 67 | 68 | 69 | 70 | 71 | 72 | 73 | 74 | 75 | 76 | 77 |

var config = {
	diagrams: [
		// 1
		{
			title: "Bruttoinlandsprodukt in den EU-Staaten seit Vollendung des EU-Binnenmarktes (1993-2016)",
			legend_title: "Legende:",					// [optional] default: undefined, @type:string, Der Titel, der über der Legende Stehen soll. 
			column_xAxis: 0, // Spalten-Nr. A
			label_xAxis: "Jahr",
			label_yAxis: "US-Dollar in Billionen",
			unitScaleFactor: 1/1000000000000,			// [optional] default: 1, Skalierungfaktor für die Y-Werte, auch als Divisor verwendbar (z.B. für dia Angabe in Tausend 1/1000)
			yAxis_numberOfDigitsAfterDecimalPoint: 2,	// [optional] default: 0, Anzahl der Dezimalstellen
			ml_tooltip_numberOfDigitsAfterDecimalPoint: 3, // [optional] default: 0, Anzahl der Dezimalstellen im Tooltip
			ml_htmlLegend_numberOfColumns: 2,			// [optional] default: 1, HTMLLegende kann mehrspaltig angezeigt werden
			ml_htmlLegend_numberOfColumns_rwd: {'xs':1, 'sm':2, 'md':3, 'lg':4},			// [optional], HTMLLegende mehrspaltig (RWD) abhängig von viewport-Größe
			rangeSlider_hidden: true,					// [optional] default: false, Range-Slider zeigen/verstecken
			ml_tooltip_legendTitlePosition: 'none',		// [optional] default: 'none', Position des Legenden-Titels im Tooltip. Werte: 'none', 'head', 'body'
			ml_tooltip_legendTitleSuffix: ': ',			// [optional] default: '<br>', Markup oder Text, der hinter den Legenden-Titel angefügt wird
			ml_tooltip_valueSuffix: '&nbsp;%',			// [optional] default: '', Markup oder Text, der hinter den y-Wert angefügt wird
			ml_tooltip_mode: 'index',					// [optional] default: 'nearest', Die Art wie Werte im Tooltip angezeigt werden. 'index': alle y-Werte aller sichtbaren datasets
														// siehe http://www.chartjs.org/docs/latest/general/interactions/modes.html
			ml_tooltip_widthScaleFactor_rwd: {'xs':0.5, 'sm':0.5, 'md':0.33, 'lg':0.33},	// [optional], Skalierungsfaktor für die Tooltip-Breite in Bezug auf den Chart-Container (panel)
			ml_tooltip_customTextPosition: 'head',		// [optional] default: 'body', Position des CustomTooltipTexts. Werte: 'body', 'head'
			ml_yAxis_dynamicScaling: false,				// [optional] default: false, Y-Achsen-Skala wird dynamisch verändert, je nach Werten
			ml_yAxis_maxValue: undefined,				// [optional] default: undefined, @type:number, Y-Achse: Maximal-Wert
			ml_yAxis_stepSize: undefined,				// [optional] default: undefined, @type:number, Y-Achse: Scalen-Einteilung
			ml_xAxis_autoSkip: true,					// [optional] default: true, X-Achsen-Skala wird dynamisch verändert bzw. werden Werte ausgelassen, je nachdem wieviel Platz zur Verfügung steht (@since 1.4.0)
			maxBarThickness: undefined,					// [optional] default: undefined, @type:number, maximale Breite von Balken bei barcharts
			ml_stackedBarChart: true,					// [optional] default: false, @type:boolean, Balken zum gleichen x-Wert gehörig können übereinander gestapelt werden, statt nebeneinander
			charts: [
				{
					// Belgien
					type: "line", // Werte: "line" || "bar"
					column_yValues: 1, // Spalten-Nr. B
					hidden: false
				},
				{
					// Deutschland
					type: "line", // Werte: "line" || "bar"
					column_yValues: 2, // Spalten-Nr. C
					hidden: true
				}
			]
		}
	],
	colors: [														// es müssen mindestenst so viele Farbwerte angegeben werden, wie die max. Anzahl charts, die in einem Diagramm dargestellt werden sollen
		{
			backgroundColor:	'#feff41', 
			borderColor:		'#feff41'
		},
		{
			backgroundColor:	'#fed22b', 
			borderColor:		'#fed22b'
		},
		{
			backgroundColor:	'#fea817', 
			borderColor:		'#fea817'
		}
	],
	watchmode: 'single'												// [optional] Werte: 'compare' (default) || 'single'
	watchmode_resetOnToggle: false,									// [optional] Werte: true (default) || false, setzt alle SelectionMenues zurück, wenn zwischen den Anzeige-Modi ("single" und "compare") umgeschaltet wird
	watchmode_openFirstAvailableChartOnCompareMode: true,			// [optional] Werte: true || false (default), öffnet bei Wahl des Vergleichsmodus automatisch die nächste zur Verfügung stehende Chart im 2. Select-Menü (watchmode_resetOnToggle muss false sein!)
	ml_pointRadius_rwd: {'xs':2, 'sm':3, 'md':4, 'lg':5},			// [optional] Punktradius bei Linien-Diagrammen (RWD)
	ml_label_fontStyle: 'normal',									// [optional] default: 'normal', @type:string, Schrift-Stil der Achsen-Beschriftung. Werte: 'normal', 'bold', 'italic', 'oblique'
	ml_label_fontSize: undefined									// [optional] default: undefined, @type:number, Schriftgröße der Achsen-Beschriftung
};
*/

var config = {
	diagrams: [
		// 1
		// Spalte 0 ist hier Dummy, da die Umwandlung von CSV zu data.js fehlerbehaftet war (Separator konnte nicht ermittelt werden)
		{
			title: "Erwerbsfähige Empfänger:innen von Bürgergeld in Deutschland nach Gruppen im Juni 2025",
			column_xAxis: 1, // Spalten-Nr. B
			label_xAxis: "",
			label_yAxis: "Anzahl erwerbsfähiger Leistungsempfänger:innen in Mio.",
			unitScaleFactor: 1, // default: 1
			yAxis_numberOfDigitsAfterDecimalPoint: 1,
			ml_tooltip_numberOfDigitsAfterDecimalPoint: 1,
			//ml_htmlLegend_numberOfColumns: 3,
			ml_htmlLegend_numberOfColumns_rwd: {'xs':2, 'sm':2, 'md':3, 'lg':4},
			ml_tooltip_legendTitlePosition: 'body',
			ml_tooltip_legendTitleSuffix: ': ',
			ml_tooltip_valueSuffix: '&nbsp; Mio. €',
			ml_tooltip_widthScaleFactor_rwd: {'xs':0.55, 'sm':0.55, 'md':0.40, 'lg':0.40},
			ml_yAxis_dynamicScaling: true,
			ml_yAxis_maxValue: 2,
			charts: [
				{
					// Anzahl erwerbsfähiger Leistungsempfänger:innen
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 2, // Spalten-Nr. C
					hidden: false
				}
			]
		},
		// 2
		{
			title: "Bundesausgaben für Arbeitslosengeld II (Hartz IV) / Bürgergeld in Deutschland seit 2016",
			column_xAxis: 3, // Spalten-Nr. D
			label_xAxis: "Jahr",
			label_yAxis: "Bundesausgaben in Milliarden Euro",
			unitScaleFactor: 1, // default: 1
			yAxis_numberOfDigitsAfterDecimalPoint: 0,
			ml_tooltip_numberOfDigitsAfterDecimalPoint: 1,
			//ml_htmlLegend_numberOfColumns: 3,
			ml_htmlLegend_numberOfColumns_rwd: {'xs':2, 'sm':2, 'md':3, 'lg':4},
			ml_tooltip_legendTitlePosition: 'body',
			ml_tooltip_legendTitleSuffix: ': ',
			ml_tooltip_valueSuffix: '&nbsp;Mrd. €',
			ml_tooltip_mode: 'nearest',
			ml_tooltip_widthScaleFactor_rwd: {'xs':0.55, 'sm':0.55, 'md':0.40, 'lg':0.40},
			ml_yAxis_dynamicScaling: false,
			//ml_yAxis_maxValue: 50,
			ml_stackedBarChart: true,
			ml_yAxis_stepSize: 10,
			charts: [
				{
					// Regelsätze
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 4, // Spalten-Nr. E
					hidden: false,
					column_tooltips: 6 // Spalten-Nr. G Tooltip
				},
				{
					// Beteiligung an Unterkunft und Heizung
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 5, // Spalten-Nr. F
					hidden: false,
					column_tooltips: 6 // Spalten-Nr. G Tooltip
				}
			]
		},
		// 3
		{
			title: "Empfänger:innen von Bürgergeld in Deutschland nach den 10 wichtigsten Herkunftsländern im Juni 2025",
			column_xAxis: 7, // Spalten-Nr. H
			label_xAxis: "",
			label_yAxis: "Empfänger:innen in Mio.",
			unitScaleFactor: 1/1000000, // default: 1
			yAxis_numberOfDigitsAfterDecimalPoint: 1,
			ml_tooltip_numberOfDigitsAfterDecimalPoint: 2,
			//ml_htmlLegend_numberOfColumns: 3,
			ml_htmlLegend_numberOfColumns_rwd: {'xs':2, 'sm':2, 'md':3, 'lg':4},
			ml_tooltip_legendTitlePosition: 'body',
			ml_tooltip_legendTitleSuffix: ': ',
			ml_tooltip_valueSuffix: '&nbsp;Mio. €',
			ml_tooltip_widthScaleFactor_rwd: {'xs':0.55, 'sm':0.55, 'md':0.40, 'lg':0.40},
			ml_yAxis_dynamicScaling: false,
			ml_yAxis_maxValue: 3000000,
			charts: [
				{
					// Euro
					type: "bar", // Werte: "line" || "bar"
					column_yValues: 8, // Spalten-Nr. I
					hidden: false
				}
			]
		}
	],
	colors: [
		{
			backgroundColor:	colorObj._1,
			borderColor:		colorObj._1
		},
		{
			backgroundColor:	colorObj._4,
			borderColor:		colorObj._4
		},
		{
			backgroundColor:	colorObj._3,
			borderColor:		colorObj._3
		}
	],
	watchmode: 'single', // Werte: 'single' || 'compare'
	watchmode_resetOnToggle: false, // Werte: true (default) || false
	watchmode_openFirstAvailableChartOnCompareMode: false, // Werte: true || false (default); watchmode_resetOnToggle muss false sein!
	watchmode_resetAlwaysOnSingleMode: true, // default: true
	ml_pointRadius_rwd: {'xs':2, 'sm':3, 'md':4, 'lg':5},
	ml_label_fontStyle: 'bold' // [optional] default: 'normal', @type:string, Schrift-Stil der Achsen-Beschriftung. Werte: 'normal', 'bold', 'italic', 'oblique'
};